# Copyright 2022 - 2024 Roland Pihlakas. https://github.com/levitation-opensource/multiobjective-ai-safety-gridworlds
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or  implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================

from __future__ import absolute_import, division, print_function

import os

from aintelope.environments.ai_safety_gridworlds.aintelope_savanna import *
from ai_safety_gridworlds.environments.shared.safety_game_moma import override_flags


def init_experiment_flags():
    FLAGS = define_flags()

    FLAGS.level = 3

    FLAGS.observation_radius = [1] * 4
    FLAGS.map_randomization_frequency = 0  # off

    FLAGS.action_direction_mode = 0  # 0 - fixed, 1 - relative, depending on last move, 2 - relative, controlled by separate turning actions

    FLAGS.MOVEMENT_SCORE = mo_reward({"MOVEMENT": 0})

    FLAGS.FOOD_DEFICIENCY_SCORE = mo_reward({"FOOD_DEFICIENCY": 0})
    # Need to be at least 7 else the agent does nothing. The bigger the value the more exploration is allowed
    FLAGS.FOOD_SCORE = mo_reward({"FOOD": 1})

    FLAGS.amount_food_patches = 1
    FLAGS.amount_drink_holes = 0
    FLAGS.amount_gold_deposits = 0
    FLAGS.amount_silver_deposits = 0
    FLAGS.amount_water_tiles = 0
    FLAGS.amount_predators = 0
    FLAGS.amount_agents = 1

    return FLAGS


class AIntelopeSavannaEnvironmentMaExperiment(AIntelopeSavannaEnvironmentMa):
    """Python environment for the savanna environment."""

    def __init__(self, FLAGS=None, **kwargs):
        """Builds a `AIntelopeSavannaEnvironmentMaExperiment` python environment.

        Returns: An `Experiment-Ready` python environment interface for this game.
        """

        FLAGS = override_flags(init_experiment_flags, FLAGS)
        super(AIntelopeSavannaEnvironmentMaExperiment, self).__init__(
            FLAGS=FLAGS, **kwargs
        )


def main(unused_argv):
    FLAGS = init_experiment_flags()
    env = AIntelopeSavannaEnvironmentMaExperiment()

    for episode_no in range(0, 1000):
        env.reset()
        ui = safety_ui_ex.make_human_curses_ui_with_noop_keys(
            GAME_BG_COLOURS, GAME_FG_COLOURS, noop_keys=FLAGS.noops
        )
        ui.play(env)


if __name__ == "__main__":
    try:
        app.run(main)
    except Exception as ex:
        print(ex)
        print(traceback.format_exc())
